<?php
/**
 * Cleanup script on uninstall.
 *
 * IMPORTANT: Support System data (tickets, users, purchase codes) is PRESERVED
 * during uninstall to maintain support history. These tables are NOT deleted:
 * - support_users
 * - support_tickets
 * - support_replies
 * - support_purchase_codes
 *
 * @package StockGuardianPro
 */

declare(strict_types=1);

if (! defined('ABSPATH')) {
    exit;
}

if (! defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

global $wpdb;

// Plugin-specific tables (Stock Guardian Pro core functionality)
// These WILL be deleted on uninstall
$woolsn_tables = [
    $wpdb->prefix . 'low_stock_thresholds',
    $wpdb->prefix . 'low_stock_events',
];

// phpcs:disable WordPress.DB.PreparedSQL.InterpolatedNotPrepared, WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.DirectDatabaseQuery.SchemaChange
foreach ($woolsn_tables as $woolsn_table) {
    $wpdb->query("DROP TABLE IF EXISTS {$woolsn_table}");
}
// phpcs:enable

// Support System tables are PRESERVED - DO NOT DELETE
// These tables maintain support ticket history and user data:
// - {$wpdb->prefix}support_users (preserved)
// - {$wpdb->prefix}support_tickets (preserved)
// - {$wpdb->prefix}support_replies (preserved)
// - {$wpdb->prefix}support_purchase_codes (preserved)

// Plugin-specific options (Stock Guardian Pro core)
// Support system options are preserved to maintain configuration
$woolsn_options = [
    'woolsn_default_threshold',
    'woolsn_notifications_email',
    'woolsn_email_subject_template',
    'woolsn_email_intro_message',
    'woolsn_email_footer_message',
    'woolsn_telegram_enabled',
    'woolsn_telegram_bot_token',
    'woolsn_telegram_chat_id',
    'woolsn_db_version',
];

foreach ($woolsn_options as $woolsn_option) {
    delete_option($woolsn_option);
}

// Support System options are PRESERVED - DO NOT DELETE
// These options maintain support system configuration:
// - woolsn_envato_api_token (preserved)
// - woolsn_envato_item_ids (preserved)
// - woolsn_support_rules_version (preserved)
// - woolsn_support_rules_flushed (preserved)

wp_cache_flush();

