<?php
declare(strict_types=1);

/**
 * HTML email template: low stock alert.
 *
 * @package StockGuardianPro
 *
 * @var string $email_heading
 * @var string $product_name
 * @var string $product_sku
 * @var string $product_admin_url
 * @var string $product_public_url
 * @var int    $stock
 * @var int    $threshold
 * @var string $store_name
 * @var string $generated_at
 */

defined('ABSPATH') || exit;
?>

<p><?php printf(esc_html__('Hello,', 'stock-guardian-pro')); ?></p>

<?php if (! empty($email_intro)) : ?>
    <?php echo wp_kses_post(wpautop($email_intro)); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
<?php endif; ?>

<p>
    <?php
    printf(
        /* translators: 1: product name, 2: stock quantity, 3: threshold */
        esc_html__(
            'The product %1$s has reached an available stock of %2$d units. The configured threshold is %3$d.',
            'stock-guardian-pro'
        ),
        '<strong>' . esc_html($product_name) . '</strong>',
        (int) $stock,
        (int) $threshold
    );
    ?>
</p>

<table cellpadding="0" cellspacing="0" style="width:100%; border:1px solid #e5e5e5; border-collapse:collapse;">
    <tbody>
    <tr>
        <th align="left" style="padding:12px; border-bottom:1px solid #e5e5e5; background:#f8f8f8; width:30%;">
            <?php esc_html_e('Product name', 'stock-guardian-pro'); ?>
        </th>
        <td style="padding:12px; border-bottom:1px solid #e5e5e5;">
            <?php echo esc_html($product_name); ?>
        </td>
    </tr>
    <tr>
        <th align="left" style="padding:12px; border-bottom:1px solid #e5e5e5; background:#f8f8f8;">
            <?php esc_html_e('SKU', 'stock-guardian-pro'); ?>
        </th>
        <td style="padding:12px; border-bottom:1px solid #e5e5e5;">
            <?php echo esc_html($product_sku ?: '—'); ?>
        </td>
    </tr>
    <tr>
        <th align="left" style="padding:12px; border-bottom:1px solid #e5e5e5; background:#f8f8f8;">
            <?php esc_html_e('Current stock', 'stock-guardian-pro'); ?>
        </th>
        <td style="padding:12px; border-bottom:1px solid #e5e5e5;">
            <?php echo esc_html((string) $stock); ?>
        </td>
    </tr>
    <tr>
        <th align="left" style="padding:12px; border-bottom:1px solid #e5e5e5; background:#f8f8f8;">
            <?php esc_html_e('Configured threshold', 'stock-guardian-pro'); ?>
        </th>
        <td style="padding:12px; border-bottom:1px solid #e5e5e5;">
            <?php echo esc_html((string) $threshold); ?>
        </td>
    </tr>
    <tr>
        <th align="left" style="padding:12px; border-bottom:1px solid #e5e5e5; background:#f8f8f8;">
            <?php esc_html_e('Generated on', 'stock-guardian-pro'); ?>
        </th>
        <td style="padding:12px; border-bottom:1px solid #e5e5e5;">
            <?php echo esc_html($generated_at); ?>
        </td>
    </tr>
    </tbody>
</table>

<p style="margin-top:20px;">
    <a href="<?php echo esc_url($product_admin_url); ?>" style="display:inline-block; padding:10px 18px; background:#2271b1; color:#fff; text-decoration:none; border-radius:4px;">
        <?php esc_html_e('Edit product in WooCommerce', 'stock-guardian-pro'); ?>
    </a>
</p>

<p>
    <small>
        <?php
        printf(
            /* translators: 1: product URL */
            esc_html__('Public link: %1$s', 'stock-guardian-pro'),
            '<a href="' . esc_url($product_public_url) . '">' . esc_html($product_public_url) . '</a>'
        );
        ?>
    </small>
</p>

<?php if (! empty($email_footer)) : ?>
    <?php echo wp_kses_post(wpautop($email_footer)); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
<?php endif; ?>

<p>
    <?php
    printf(
        /* translators: %s store name */
        esc_html__('Regards from the %s team.', 'stock-guardian-pro'),
        esc_html($store_name)
    );
    ?>
</p>

