<?php
declare(strict_types=1);

/**
 * Plain-text email template: low stock alert.
 *
 * @package StockGuardianPro
 */

defined('ABSPATH') || exit;

echo "====================================\n";
printf("%s\n", esc_html($email_heading));
echo "====================================\n\n";

if (! empty($email_intro)) {
    echo esc_html(wp_strip_all_tags($email_intro)) . "\n\n";
}

printf(
    /* translators: 1: product name, 2: stock quantity, 3: threshold */
    esc_html__(
        'The product %1$s has reached an available stock of %2$d units (configured threshold: %3$d).',
        'stock-guardian-pro'
    ),
    esc_html($product_name),
    (int) $stock,
    (int) $threshold
);
echo "\n\n";

printf(
    /* translators: %s product SKU */
    esc_html__('SKU: %s', 'stock-guardian-pro'),
    esc_html($product_sku ?: '—')
);
echo "\n";

printf(
    /* translators: %s generation date and time */
    esc_html__('Generated on: %s', 'stock-guardian-pro'),
    esc_html($generated_at)
);
echo "\n";

printf(
    /* translators: %s product admin URL */
    esc_html__('Edit product: %s', 'stock-guardian-pro'),
    esc_url($product_admin_url)
);
echo "\n";

printf(
    /* translators: %s product public URL */
    esc_html__('Public link: %s', 'stock-guardian-pro'),
    esc_url($product_public_url)
);
echo "\n\n";

if (! empty($email_footer)) {
    echo esc_html(wp_strip_all_tags($email_footer)) . "\n\n";
}

printf(
    /* translators: %s store name */
    esc_html__('Regards from the %s team.', 'stock-guardian-pro'),
    esc_html($store_name)
);
echo "\n";

