<?php
/**
 * Plugin Name: Stock Guardian Pro
 * Plugin URI:  https://xtremecode.eu/
 * Description: Advanced WooCommerce low stock notifications with dynamic thresholds and external integrations.
 * Version:     0.2.0
 * Author:      Xtreme Code
 * Author URI:  https://codecanyon.net/user/xtremecode
 * Text Domain: stock-guardian-pro
 * Domain Path: /languages
 * Requires at least: 6.2
 * Requires PHP: 7.4
 * License: GPLv2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 *
 * @package StockGuardianPro
 */

declare(strict_types=1);

if (! defined('ABSPATH')) {
    exit;
}

if (! defined('WOOLSN_PLUGIN_FILE')) {
    define('WOOLSN_PLUGIN_FILE', __FILE__);
}

if (! defined('WOOLSN_VERSION')) {
    define('WOOLSN_VERSION', '0.2.0');
}

spl_autoload_register(
    static function (string $class): void {
        $namespace = 'StockGuardianPro\\LowStock\\';

        if (strpos($class, $namespace) !== 0) {
            return;
        }

        $relative      = substr($class, strlen($namespace));
        $relative_path = str_replace('\\', DIRECTORY_SEPARATOR, $relative) . '.php';
        $path          = plugin_dir_path(__FILE__) . 'includes/' . $relative_path;

        if (file_exists($path)) {
            require_once $path;
        }
    }
);

StockGuardianPro\LowStock\Plugin::get_instance()->boot();

// Show activation error notice even if plugin is deactivated
// This must be in the main plugin file to work even after deactivation
add_action('admin_notices', function () {
    if (get_transient('woolsn_activation_error')) {
        $plugin = StockGuardianPro\LowStock\Plugin::get_instance();
        if (method_exists($plugin, 'render_activation_error_notice')) {
            $plugin->render_activation_error_notice();
        }
    }
}, 1); // Priority 1 to show early

$woolsn_plugin_basename = plugin_basename(WOOLSN_PLUGIN_FILE);

add_filter(
    "plugin_action_links_{$woolsn_plugin_basename}",
    static function (array $links): array {
        $settings_url  = admin_url('admin.php?page=stock-guardian-pro&tab=settings');
        $settings_link = '<a href="' . esc_url($settings_url) . '">' . esc_html__('Settings', 'stock-guardian-pro') . '</a>';

        array_unshift($links, $settings_link);

        return $links;
    }
);

