<?php
/**
 * Centralized logging service.
 *
 * @package StockGuardianPro
 */

declare(strict_types=1);

namespace StockGuardianPro\LowStock\Services;

use StockGuardianPro\LowStock\Plugin;
use WC_Logger;

\defined('ABSPATH') || exit;

final class LoggerService implements ServiceInterface
{
    private Plugin $plugin;

    private WC_Logger $logger;

    public function __construct(Plugin $plugin)
    {
        $this->plugin = $plugin;
        $this->logger = wc_get_logger();
    }

    public function register(): void
    {
    }

    public function info(string $message, array $context = []): void
    {
        $this->logger->info($message, $this->context($context));
    }

    public function warning(string $message, array $context = []): void
    {
        $this->logger->warning($message, $this->context($context));
    }

    public function error(string $message, array $context = []): void
    {
        $this->logger->error($message, $this->context($context));
    }

    private function context(array $context): array
    {
        return array_merge(
            [
                'source' => 'stock-guardian-pro',
            ],
            $context
        );
    }
}

