<?php
/**
 * Handles plugin assets.
 *
 * @package StockGuardianPro
 */

declare(strict_types=1);

namespace StockGuardianPro\LowStock\Services;

use StockGuardianPro\LowStock\Plugin;

\defined('ABSPATH') || exit;

final class AssetsService implements ServiceInterface
{
    private Plugin $plugin;

    public function __construct(Plugin $plugin)
    {
        $this->plugin = $plugin;
    }

    public function register(): void
    {
        add_action('admin_enqueue_scripts', [$this, 'enqueue_admin']);
    }

    public function enqueue_admin(string $hook_suffix): void
    {
        if (strpos($hook_suffix, 'stock-guardian-pro') === false) {
            return;
        }

        $asset_url = plugin_dir_url(WOOLSN_PLUGIN_FILE) . 'assets/';

        wp_enqueue_style(
            'stock-guardian-pro-admin',
            $asset_url . 'css/admin.css',
            [],
            '0.2.0'
        );

        wp_enqueue_script(
            'stock-guardian-pro-admin',
            $asset_url . 'js/admin.js',
            ['wp-element', 'wp-api-fetch'],
            '0.2.0',
            true
        );

        wp_localize_script(
            'stock-guardian-pro-admin',
            'woolsnAdmin',
            [
                'root'      => esc_url_raw(rest_url(RestApiService::ROUTE_NAMESPACE)),
                'nonce'     => wp_create_nonce('wp_rest'),
                'pluginUrl' => $asset_url,
                'ajaxUrl'   => admin_url('admin-ajax.php'),
                'i18n'      => [
                ],
            ]
        );
    }
}

