# Purchase Code di Test per Sistema Support Tickets

## Panoramica

Per testare il sistema dei ticket support senza un purchase code Envato valido, puoi usare **purchase code di test** che bypassano la verifica con l'API Envato.

## Formato Purchase Code di Test

I purchase code di test seguono questo formato:

```
TEST-CODE-xxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx
```

Dove `x` rappresenta qualsiasi carattere esadecimale (0-9, a-f).

## Esempi di Purchase Code di Test

Puoi usare qualsiasi di questi esempi per testare:

### Per Stock Guardian Pro:
```
TEST-CODE-1234-5678-9abc-def0-123456789abc
```

### Per Countdown Timer Pro:
```
TEST-CODE-9876-5432-fedc-ba09-abcdef123456
```

### Purchase Code Generici (per qualsiasi prodotto):
```
TEST-CODE-0000-0000-0000-0000-000000000000
TEST-CODE-aaaa-bbbb-cccc-dddd-eeeeeeeeeeee
TEST-CODE-1111-2222-3333-4444-555555555555
```

## Come Usare

1. **Registrati al sistema support** (se non l'hai già fatto):
   - Vai su `/support/register/`
   - Completa la registrazione e verifica l'email

2. **Accedi al dashboard**:
   - Vai su `/support/login/`
   - Accedi con le tue credenziali

3. **Aggiungi un Purchase Code di Test**:
   - Nella sezione "Purchase Codes", inserisci un purchase code di test (es: `TEST-CODE-1234-5678-9abc-def0-123456789abc`)
   - Seleziona il prodotto (Stock Guardian Pro o Countdown Timer Pro)
   - Clicca su "Verify Purchase Code"
   - Il sistema accetterà automaticamente il purchase code di test senza chiamare l'API Envato

4. **Crea un Ticket**:
   - Ora puoi creare ticket usando il purchase code di test
   - Seleziona il prodotto e il purchase code dalla lista
   - Compila il form e crea il ticket

## Note Importanti

⚠️ **IMPORTANTE**: 
- I purchase code di test funzionano **SOLO per sviluppo e testing locale**
- **NON** verranno accettati in produzione se il sistema è configurato correttamente
- Sono pensati per permettere il testing del sistema ticket senza bisogno di acquistare prodotti su Envato

## Come Disabilitare i Purchase Code di Test (Produzione)

Se vuoi disabilitare i purchase code di test in produzione, puoi modificare il metodo `is_test_code()` in `PurchaseCodeService.php` per restituire sempre `false`, oppure rimuovere completamente il supporto per i test code.

## Troubleshooting

**Problema**: Il purchase code di test non viene accettato
- **Soluzione**: Verifica che il formato sia esattamente `TEST-CODE-xxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx` (con trattini e caratteri esadecimali)

**Problema**: Il ticket non viene creato anche con purchase code di test
- **Soluzione**: Assicurati di aver verificato il purchase code di test prima di creare il ticket

## Supporto

Per domande o problemi, contatta il supporto tecnico.






