# 🔒 PRESERVAZIONE DATI SUPPORT SYSTEM

## ⚠️ IMPORTANTE

Il sistema di support ticket è progettato per **preservare tutti i dati** durante:
- ✅ Aggiornamenti del plugin
- ✅ Disinstallazione e reinstallazione
- ✅ Deattivazione e riattivazione

## 📊 Tabelle Preservate

Le seguenti tabelle del database **NON vengono eliminate** durante la disinstallazione:

1. **`wp_support_users`** - Utenti registrati al supporto
2. **`wp_support_tickets`** - Ticket di supporto
3. **`wp_support_replies`** - Risposte ai ticket
4. **`wp_support_purchase_codes`** - Codici di acquisto verificati

## ⚙️ Opzioni Preservate

Le seguenti opzioni WordPress **NON vengono eliminate** durante la disinstallazione:

1. **`woolsn_envato_api_token`** - Token API Envato
2. **`woolsn_envato_item_ids`** - Mapping Item ID → Product
3. **`woolsn_support_rules_version`** - Versione rewrite rules
4. **`woolsn_support_rules_flushed`** - Flag flush rewrite rules

## 🔄 Come Funziona

### Durante Aggiornamenti

1. Il sistema usa `dbDelta()` che **preserva i dati esistenti**
2. Le migrazioni modificano solo la struttura delle tabelle se necessario
3. I dati esistenti **non vengono toccati**

### Durante Disinstallazione

1. Il file `uninstall.php` elimina SOLO le tabelle del plugin principale:
   - `wp_low_stock_thresholds`
   - `wp_low_stock_events`
2. Le tabelle del support system **vengono preservate**
3. Le opzioni del support system **vengono preservate**

### Dopo Reinstallazione

1. Il sistema verifica se le tabelle esistono già
2. Se esistono, le usa (con eventuali migrazioni se necessario)
3. Se non esistono, le crea da zero
4. **I dati storici rimangono intatti**

## 📝 Note Tecniche

### Migrazioni Database

Il sistema di migrazione (`SchemaMigrator`) usa:
- `dbDelta()` per creare/modificare tabelle
- Versioning (`DB_VERSION`) per tracciare le migrazioni
- Controlli di esistenza prima di creare nuove tabelle

### Uninstall Hook

Il file `uninstall.php` è configurato per:
- Eliminare SOLO dati del plugin principale (Stock Guardian Pro)
- **Preservare** tutti i dati del support system
- Commenti espliciti per evitare eliminazioni accidentali

## ✅ Verifica

Per verificare che i dati siano preservati dopo un aggiornamento:

1. Controlla che le tabelle esistano:
   ```sql
   SHOW TABLES LIKE 'wp_support_%';
   ```

2. Verifica il numero di record:
   ```sql
   SELECT COUNT(*) FROM wp_support_users;
   SELECT COUNT(*) FROM wp_support_tickets;
   SELECT COUNT(*) FROM wp_support_replies;
   ```

3. Dopo reinstallazione, i numeri devono essere identici.

## 🚨 Attenzione

Se vuoi eliminare completamente i dati del support system, devi farlo manualmente dal database o creare uno script dedicato. **Il sistema non elimina mai automaticamente questi dati**.







