# Countdown Timer Pro

A premium countdown/countup timer with **Conversion Optimization**, **Cross-Tab Synchronization**, and **Behavioral Targeting Engine**. Built with HTML5 Canvas and jQuery, featuring advanced local A/B testing and optimization capabilities.

## 🚀 Three Advanced Features

### 🤖 1. Conversion Optimization (Local A/B Testing)
**Automatic variant tracking and optimization based on local conversion data.**

- **Automatic A/B Testing** - Creates and tests multiple timer variants automatically
- **Variant Tracking** - Tracks which timer configurations perform best locally
- **Auto-Apply Best Variant** - Automatically applies the best performing style based on local statistics
- **Conversion Tracking** - Built-in analytics track clicks, views, and conversions locally
- **Performance Analytics** - Detailed statistics on which configurations perform best
- **Zero Configuration** - Works automatically once enabled
- **Privacy-First** - All data stored locally in browser localStorage (no external servers)

### 🔄 2. Cross-Tab Synchronization
**Synchronize timer state across browser tabs/windows with optional WebSocket server support.**

- **WebSocket Support** - Real-time sync via WebSocket (requires optional server setup)
- **localStorage Fallback** - Works without server using browser localStorage for cross-tab sync
- **Live Viewer Count** - Shows "X people watching" in real-time (cross-tab or multi-user if server configured)
- **Automatic Sync** - Timer synchronizes across all instances automatically
- **Room System** - Isolate different timers using unique room IDs
- **Connection Status** - Visual indicator showing sync status
- **Note:** Multi-user synchronization across different devices/browsers requires a WebSocket server (not included)

### 🎯 3. Behavioral Targeting Engine
**Adapt timer based on user behavior and traffic source.**

- **Smart Visitor Detection** - Detects new vs returning visitors using localStorage
- **Device-Based Targeting** - Different durations for mobile, tablet, desktop
- **Traffic Source Targeting** - Customize based on source (social, email, direct, search)
- **Priority-Based Rules** - Configure rules with priority order
- **Automatic Application** - Rules apply automatically based on detected behavior
- **Conversion Optimization** - Show right urgency level to each user segment

## Core Features

- ✅ **Responsive Design** - Works perfectly on all devices and screen sizes with optimized mobile layout
- ✅ **Visual Customizer Panel** - Complete no-code customization interface with real-time preview
- ✅ **13 Premium Presets** - Beautiful pre-designed styles (Premium Base, Luxury Gold, Dark Neon, Glassmorphism, Minimalist, Cyberpunk, Elegant Classic, Ocean Breeze, Sunset Glow, Forest Green, Black Friday, Christmas, Product Launch)
- ✅ **Liquid Effect** - Revolutionary 3D liquid animation with realistic waves, bubbles, and evaporation (always enabled)
- ✅ **Pulse Glow Animation** - Pulsating glow effect on circle borders
- ✅ **Gradient Wave Animation** - Animated gradient waves on circle borders
- ✅ **Countdown & Countup** - Support for both countdown and countup modes
- ✅ **Client & Server-side Time** - Works with client duration or server Unix timestamps
- ✅ **HTML5 Canvas Rendering** - Smooth, high-performance animations
- ✅ **Resizable** - Customizable width, height, font size, and circle thickness
- ✅ **Easy Customization** - Change fonts and colors easily via Customizer Panel or code
- ✅ **Multicolor Circles** - Dynamic color transitions over time
- ✅ **Show/Hide Units** - Control which time units to display (days, hours, minutes, seconds)
- ✅ **Customizable Texts** - Change all text labels via parameters
- ✅ **Multiple Instances** - Support for multiple timers on the same page
- ✅ **Expire Actions** - Hide, redirect, or show message when timer finishes
- ✅ **Auto Reset** - Automatically reset timer at intervals
- ✅ **Celebration Animations** - Confetti and particle effects when timer finishes
- ✅ **Sound Effects** - Optional tick and finish sounds
- ✅ **3D Effects** - Shadows, parallax, and rotation effects
- ✅ **Background Patterns** - Grid, dots, lines, and diagonal patterns
- ✅ **Cross-browser** - Works in modern browsers (Chrome, Firefox, Safari, Edge, Opera)
- ✅ **Mobile Compatible** - Fully responsive with optimized vertical layout for mobile devices

## Installation

1. Include jQuery (required):
```html
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
```

2. Include Countdown Timer Pro files:
```html
<link rel="stylesheet" href="countdown-timer-pro.css">
<script src="countdown-timer-pro.js"></script>
```

3. Create a container element:
```html
<div id="my-timer" class="countdown-timer-pro"></div>
```

4. Initialize the timer:
```javascript
$('#my-timer').countdownTimerPro({
    timeType: 'countdown',
    duration: 3600 // 1 hour in seconds
});
```

## Basic Usage

### Simple Countdown
```javascript
$('#timer').countdownTimerPro({
    timeType: 'countdown',
    duration: 3600, // seconds
    width: 800,
    height: 400
});
```

### Countup Timer
```javascript
$('#timer').countdownTimerPro({
    timeType: 'countup',
    startTime: Math.floor(Date.now() / 1000) - 3600, // Started 1 hour ago
    width: 800,
    height: 400
});
```

### Server-side Timestamp
```javascript
$('#timer').countdownTimerPro({
    timeType: 'countdown',
    timeSource: 'server',
    endTime: 1734567890, // Unix timestamp (seconds)
    width: 800,
    height: 400
});
```

## Configuration Options

### Timer Type
- `timeType` (string): `'countdown'` or `'countup'` (default: `'countdown'`)

### Time Source
- `timeSource` (string): `'client'` or `'server'` (default: `'client'`)
- `duration` (number): Duration in seconds (for client-side countdown)
- `endTime` (number): Unix timestamp in seconds (for server-side countdown)
- `startTime` (number): Unix timestamp in seconds (for countup, null for current time)

### Display Options
- `showDays` (boolean): Show/hide days (default: `true`)
- `showHours` (boolean): Show/hide hours (default: `true`)
- `showMinutes` (boolean): Show/hide minutes (default: `true`)
- `showSeconds` (boolean): Show/hide seconds (default: `true`)

### Size Options
- `width` (number): Canvas width in pixels (default: `800`)
- `height` (number): Canvas height in pixels (default: `400`)
- `fontSize` (number): Font size in pixels (default: `48`)
- `circleThickness` (number): Circle stroke width in pixels (default: `8`)

### Color Options
```javascript
colors: {
    circle: '#3498db',           // Progress circle color
    circleBackground: '#ecf0f1',  // Background circle color
    text: '#2c3e50'              // Text color
}
```

### Font Options
- `fontFamily` (string): Font family (default: `'Arial, sans-serif'`)
- `fontWeight` (string): Font weight for numbers - `'normal'`, `'bold'`, `'lighter'`, `'bolder'`, or numeric `'100'`-`'900'` (default: `'bold'`)
- `labelFontWeight` (string): Font weight for labels (default: `'normal'`)

### Multicolor Options
```javascript
multicolor: {
    enabled: false,
    colors: ['#3498db', '#e74c3c', '#2ecc71', '#f39c12']
}
```

### Liquid Effect (Always Enabled - Distinctive Visual Feature)
```javascript
liquidEffect: {
    enabled: true,        // Always enabled - distinctive visual feature
    intensity: 1.2,       // Wave intensity (0.5 to 2.0)
    bubbleSpeed: 1.0,     // Bubble rise speed (0.5 to 2.0)
    waveSpeed: 1.0,       // Wave animation speed (0.5 to 2.0)
    bubbleSpawnRate: 0.8, // Bubble spawn frequency (0.5 to 1.5)
    showEvaporation: true, // Show evaporation particles
    liquidColor: null     // Custom liquid color (null = use circle color)
}
```

### Pulse Glow Animation
```javascript
pulseGlow: {
    enabled: false,
    intensity: 1.0,  // Glow intensity (0.5 to 2.0)
    speed: 1.0      // Animation speed (0.5 to 2.0)
}
```

### Gradient Wave Animation
```javascript
gradientWave: {
    enabled: false,
    colors: ['#667eea', '#764ba2', '#f093fb', '#4facfe'], // Gradient colors
    speed: 1.0  // Animation speed (0.5 to 2.0)
}
```

### Text Labels
```javascript
texts: {
    days: 'DAYS',
    hours: 'HOURS',
    minutes: 'MINUTES',
    seconds: 'SECONDS'
}
```

### Expire Actions
- `expireAction` (string): `'none'`, `'hide'`, `'redirect'`, or `'message'` (default: `'none'`)
- `expireMessage` (string): Message to show when timer expires
- `expireRedirectUrl` (string): URL to redirect to when timer expires

### Auto Reset
```javascript
autoReset: {
    enabled: false,
    unit: 'minutes', // 'minutes', 'hours', or 'days'
    value: 1
}
```

### Celebration Animations
```javascript
celebration: {
    enabled: true,
    type: 'both',  // 'confetti', 'particles', or 'both'
    intensity: 1.0,  // Animation intensity (0.5 to 2.0)
    colors: ['#667eea', '#764ba2', '#f093fb', '#4facfe', '#43e97b', '#fa709a', '#fee140', '#30cfd0']
}
```

### Sound Effects
```javascript
sound: {
    enabled: false,
    tickEnabled: true,      // Play tick sound each second
    tickVolume: 0.3,       // Tick volume (0.0 to 1.0)
    finishEnabled: true,   // Play sound when timer finishes
    finishVolume: 0.5,     // Finish volume (0.0 to 1.0)
    tickFrequency: 800,    // Tick sound frequency (Hz)
    finishFrequency: 600   // Finish sound frequency (Hz)
}
```

### 3D Effects
```javascript
effects3D: {
    enabled: false,
    shadowDepth: 20,         // Shadow depth in pixels
    rotationSpeed: 0,        // Rotation speed (0 = no rotation)
    parallaxIntensity: 0,    // Parallax effect intensity (0 = disabled)
    lightingIntensity: 0.5   // Lighting intensity (0.0 to 1.0)
}
```

### Background Patterns
```javascript
backgroundPattern: {
    enabled: false,
    type: 'grid',  // 'grid', 'dots', 'lines', 'diagonal', or 'none'
    color: '#e0e0e0',
    size: 20,
    spacing: 10
}
```

### Callbacks
- `onFinish` (function): Callback function called when timer finishes

## Methods

### Start Timer
```javascript
$('#timer').countdownTimerPro('start');
```

### Stop Timer
```javascript
$('#timer').countdownTimerPro('stop');
```

### Reset Timer
```javascript
$('#timer').countdownTimerPro('reset');
```

### Destroy Timer
```javascript
$('#timer').countdownTimerPro('destroy');
```

## Premium Presets

Countdown Timer Pro includes 13 professionally designed presets:

1. **Premium Base** - Clean and professional design
2. **Luxury Gold** - Elegant gold theme with multicolor animation
3. **Dark Neon** - Cyberpunk neon aesthetic with vibrant colors
4. **Glassmorphism** - Modern glass effect with transparency
5. **Minimalist** - Clean minimal design for modern websites
6. **Cyberpunk** - Futuristic neon colors and bold styling
7. **Elegant Classic** - Timeless classic style with serif fonts
8. **Ocean Breeze** - Calming ocean blue tones
9. **Sunset Glow** - Warm sunset colors with orange gradients
10. **Forest Green** - Natural green theme
11. **Black Friday** - Bold red and black for sales events
12. **Christmas** - Festive red and green holiday theme
13. **Product Launch** - Vibrant purple gradient for product launches

### Using Presets

You can use the **Customizer Panel** (`customizer-panel.html`) to visually select and customize presets, or load them programmatically:

```javascript
// Example: Load Luxury Gold preset
const preset = {
    name: 'Luxury Gold',
    colors: {
        circle: '#ffd700',
        circleBackground: '#1a1a1a',
        text: '#ffffff'
    },
    multicolor: {
        enabled: true,
        colors: ['#ffd700', '#ffed4e', '#f4d03f', '#ffc107']
    },
    // ... other preset options
};

$('#timer').countdownTimerPro(preset);
```

## Visual Customizer Panel

The **Customizer Panel** (`customizer-panel.html`) provides a complete no-code interface for customizing your timer:

- **Real-time Preview** - See changes instantly
- **Preset Management** - Load, export, import, and share presets
- **Responsive Preview** - Test on Mobile, Tablet, Desktop, and Large screens
- **Code Generator** - Generate ready-to-use code
- **Export PNG** - Export timer as image
- **All Options** - Access to all customization options visually

To use the Customizer Panel, simply open `customizer-panel.html` in your browser.

## Examples

### Example 1: Basic Countdown
```javascript
$('#timer').countdownTimerPro({
    timeType: 'countdown',
    duration: 3600,
    width: 800,
    height: 400
});
```

### Example 2: Multicolor with Custom Settings
```javascript
$('#timer').countdownTimerPro({
    timeType: 'countdown',
    duration: 7200,
    multicolor: {
        enabled: true,
        colors: ['#3498db', '#e74c3c', '#2ecc71', '#f39c12']
    },
    fontSize: 56,
    circleThickness: 12,
    width: 800,
    height: 400
});
```

### Example 3: Custom Colors and Font
```javascript
$('#timer').countdownTimerPro({
    timeType: 'countdown',
    duration: 5400,
    colors: {
        circle: '#e74c3c',
        circleBackground: '#ecf0f1',
        text: '#2c3e50'
    },
    fontFamily: 'Georgia, serif',
    fontSize: 56,
    circleThickness: 12,
    width: 800,
    height: 400
});
```

### Example 4: Hide Days, Show Only H/M/S
```javascript
$('#timer').countdownTimerPro({
    timeType: 'countdown',
    duration: 3661,
    showDays: false,
    showHours: true,
    showMinutes: true,
    showSeconds: true,
    width: 600,
    height: 300
});
```

### Example 5: Custom Text Labels
```javascript
$('#timer').countdownTimerPro({
    timeType: 'countdown',
    duration: 4500,
    texts: {
        days: 'GIORNI',
        hours: 'ORE',
        minutes: 'MINUTI',
        seconds: 'SECONDI'
    },
    width: 800,
    height: 400
});
```

### Example 6: Expire with Message
```javascript
$('#timer').countdownTimerPro({
    timeType: 'countdown',
    duration: 3600,
    expireAction: 'message',
    expireMessage: 'Time is up! The event has started.',
    width: 800,
    height: 400
});
```

### Example 7: Auto Reset
```javascript
$('#timer').countdownTimerPro({
    timeType: 'countdown',
    duration: 60,
    autoReset: {
        enabled: true,
        unit: 'minutes',
        value: 1
    },
    width: 800,
    height: 400
});
```

### Example 8: Multiple Instances
```javascript
$('#timer1').countdownTimerPro({
    timeType: 'countdown',
    duration: 1800,
    width: 400,
    height: 200
});

$('#timer2').countdownTimerPro({
    timeType: 'countup',
    startTime: Math.floor(Date.now() / 1000) - 3600,
    width: 400,
    height: 200,
    colors: { circle: '#e74c3c' }
});
```

## Browser Support

- Chrome (latest)
- Firefox (latest)
- Safari (latest)
- Edge (latest)
- Opera (latest)
- Mobile browsers (iOS Safari, Chrome Mobile)
- Requires jQuery 3.x (not included - user must provide)

## Requirements

- jQuery 3.0+ (included via CDN or local file)
- Modern browser with HTML5 Canvas support

## License

This product is licensed for use according to the CodeCanyon license terms.

## Support

For support, please contact through your purchase platform (Envato CodeCanyon).

## Changelog

### Version 1.0.0
- Initial release
- All core features implemented
- Full documentation

